<?php

class WolkLicenseAuth{

    protected $authDomain = "https://wpvalidations.azurewebsites.net/APIenpointWPWolkPay.svc/WPValidateUrl";
    protected $license_key = "";
    protected $customer_email = "";
    protected $customer_domail = "";
    
    public function __construct(){
        $urlparts = wp_parse_url(home_url());
        $domain = $urlparts['host'];
        $domain = str_replace('www.','',$domain);
        if(isset($_GET['unverify'])){
            $domain = 'localhost';
        }
        $this->customer_domail =  $domain;
        
    }


    public function VerifyLicense(){
        // Cache: evita falsos INACTIVA por fallos transitorios y mejora performance.
        $cache_key = 'wolk_license_cache_' . md5($this->customer_domail);
        $cached = get_transient($cache_key);

        // Log datos enviados a la API para depuracion
        error_log('[WOLK] Dominio enviado a API de licencia: ' . $this->customer_domail);
        error_log('[WOLK] Endpoint de validacion: ' . $this->authDomain);

        // [OK] IMPORTANTE: NO usar body en GET (muchas instalaciones lo ignoran).
        $url = add_query_arg(
            array('URL_Cliente' => 'WP-PAYW-' . $this->customer_domail),
            $this->authDomain
        );

        $request = wp_remote_get($url, array(
            'timeout' => 10,
            'headers' => array('Accept' => 'application/json'),
        ));

        if (is_wp_error($request) || empty($request)) {
            // Si hay cache reciente, usalo antes de declarar TIMEOUT
            if (is_array($cached) && isset($cached['status'])) {
                $cached['from_cache'] = true;
                return $cached;
            }
            return array('status' => 200, 'timeout' => true);
        }

        $http_code = wp_remote_retrieve_response_code($request);
        $body = wp_remote_retrieve_body($request);
        if ($http_code < 200 || $http_code >= 300 || empty($body)) {
            if (is_array($cached) && isset($cached['status'])) {
                $cached['from_cache'] = true;
                return $cached;
            }
            return array('status' => 200, 'timeout' => true);
        }

        $data = json_decode($body, true);
        if($this->customer_domail == "localhost"){
            $data['status'] = 400;
            return $data;
        }
        if(!empty($data)){
            // La API devuelve arreglo con un objeto
            if (is_array($data) && isset($data[0]) && is_array($data[0])) {
                $data = $data[0];
            }

            // Normalizar claves (a veces vienen con espacios)
            $normalized = array();
            foreach ($data as $k => $v) {
                $normalized[trim((string)$k)] = $v;
            }
            $data = $normalized;

            $active = isset($data['Activo']) ? $data['Activo'] : 0;
            if($active == 1){
                // Validar fecha de expiracion si viene
                $current_date = strtotime(date('Y-m-d'));
                $expiry_raw = isset($data['Fin Contrato']) ? $data['Fin Contrato'] : (isset($data['FinContrato']) ? $data['FinContrato'] : (isset($data[' Fin Contrato']) ? $data[' Fin Contrato'] : ''));
                $expiry_date = $expiry_raw ? strtotime($expiry_raw) : 0;
                if($expiry_date < $current_date){
                    $data['status'] = 400;
                    // Cache corto para evitar flapping
                    set_transient($cache_key, $data, 10 * MINUTE_IN_SECONDS);
                    return $data;
                }else{
                    $data['status'] = 200;
                    // Cache mas largo cuando esta activa
                    set_transient($cache_key, $data, 6 * HOUR_IN_SECONDS);
                    return $data;
                }
            }else{
                $data['status'] = 400;
                set_transient($cache_key, $data, 10 * MINUTE_IN_SECONDS);
                return $data;
            }
        }else{
            $data['status'] = 400;
            return $data;
        }
    }

    public function setRegisterData($key, $email){
        $this->license_key = $key;
        $this->customer_email = $email;
    }

    public function setVerifyData($key, $email){
        $this->license_key = $key;
        $this->customer_email = $email;
    }
    public function registerLicenseKey(){
        if(!$this->license_key){
            return [
                'status' => 400,
                'msg' => 'Invalid license.'
            ];
        }else{
            return [
                'status' => 200,  
                'msg' => 'Invalid activated.'
            ];
        }
    }
}
?>