<?php
// SEGURIDAD: Bloquear acceso directo
if (!defined('ABSPATH')) {
    exit;
}

class Wolk_Payment_Gateway extends WC_Payment_Gateway
{

	private $order_status;
	public $hide_text_box;
	public $text_box_required;
	public $pluginFolder;
	public $brand_color;
	public $currency_symbol;
	public $license_key;
	public $secret_key;
	public $customer_email;
	public $site_domain;

	public function __construct()
	{
		$this->id = 'wolk_wc_payment';
		$this->method_title = __('Wolk Payment Method', 'wolk-payment-gateway');
		$this->title = __('Wolk Payment Method', 'wolk-payment-gateway');
		$this->has_fields = true;
		$this->init_form_fields();
		$this->init_settings();
		$this->enabled = $this->get_option('enabled');
		$this->title = $this->get_option('title');
		$this->description = $this->get_option('description');
		$this->hide_text_box = $this->get_option('hide_text_box');
		$this->text_box_required = $this->get_option('text_box_required');
		$this->order_status = $this->get_option('order_status');
		$this->pluginFolder = 'wolk-payment-gateway';
		$this->brand_color = $this->get_option('brand_color');
		$this->currency_symbol = $this->get_option('currency_symbol');
		$this->license_key = $this->get_option('license_key') ?? null;
		$this->secret_key = $this->get_option('secret_key');
		$this->customer_email = $this->get_option('customer_email');
		$this->site_domain = get_site_url();

		add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
		add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'clear_gateway_cache'));
	}

	/**
	 * Limpia la cache cuando se actualizan las opciones del gateway
	 */
	public function clear_gateway_cache() {
		// Limpiar cache de transients
		delete_transient('wolk_payment_gateway_settings');
		
		// Limpiar cache de WooCommerce
		WC_Cache_Helper::get_transient_version('shipping', true);
		
		// Forzar recarga de opciones
		$this->init_settings();
		
		// Limpiar cache de opciones
		wp_cache_delete('woocommerce_' . $this->id . '_settings', 'options');
	}

	public function init_form_fields()
	{
		// Obtiene la moneda actual seleccionada
		$current_currency = get_woocommerce_currency();
		$currencies = get_woocommerce_currencies();
		$currencies_options = array();

		foreach ($currencies as $key => $currency) {
			$symbol = get_woocommerce_currency_symbol($key);
			$currencies_options[$key] = $currency . " (" . $symbol . ")";
		}

		$lang_options = array(
			'en' => 'English',
			'es' => 'Spanish',
		);

		$this->form_fields = array(
			'enabled' => array(
				'title' => $this->_lang(__('Enable/Disable', 'wolk-payment-gateway')),
				'type' => 'checkbox',
				'label' => $this->_lang(__('Enable Wolk Payment', 'wolk-payment-gateway')),
				'default' => 'yes'
			),

			'title' => array(
				'title' => $this->_lang(__('Method Title', 'wolk-payment-gateway')),
				'type' => 'text',
				'description' => $this->_lang(__('This controls the title', 'wolk-payment-gateway')),
				'default' => $this->_lang(__('3D Secure - Wolk Payment', 'wolk-payment-gateway')),
				'desc_tip' => true,
				//'custom_attributes' => array( 'readonly' => true ),
			),
			'description' => array(
				'title' => $this->_lang(__('Custom Message', 'wolk-payment-gateway')),
				'type' => 'textarea',
				'css' => 'width:500px;',
				'default' => $this->_lang('custom_message_default'),
				'description' => $this->_lang(__('The message which you want it to appear to the customer in the checkout page.', 'wolk-payment-gateway')),
			),

			'order_status' => array(
				'title' => $this->_lang(__('Order Status After The Checkout', 'wolk-payment-gateway')),
				'type' => 'select',
				'options' => wc_get_order_statuses(),
				'default' => 'wc-on-hold',
				'description' => $this->_lang(__('The default order status if this gateway used in payment.', 'wolk-payment-gateway')),
			),
			'lang' => array(
				'title' => $this->_lang(__('Language', 'wolk-payment-gateway')),
				'type' => 'select',
				'options' => $lang_options,
				'default' => 'es'
			),

			'currency_symbol' => array(
				'title' => $this->_lang(__('Currency Symbol', 'wolk-payment-gateway')),
				'type' => 'select',
				'options' => $currencies_options,
				'default' => get_woocommerce_currency(),
			),

			'brand_color' => array(
				'title' => $this->_lang(__('Brand Color', 'wolk-payment-gateway')),
				'type' => 'color',
				'default' => '#0daabf',
				'label' => $this->_lang(__('Brand Color', 'wolk-payment-gateway')),
			),
			'public_key' => array(
				'title' => $this->_lang(__('Public Key', 'wolk-payment-gateway')),
				'type' => 'text',
				'label' => $this->_lang(__('Public Key', 'wolk-payment-gateway')),
				'default' => $this->_lang(__('Public Key', 'wolk-payment-gateway')),
				'description' => $this->_lang(__('You must request this information directly from your bank.', 'wolk-payment-gateway')),
			),
			'security_key' => array(
				'title' => $this->_lang(__('Security Key', 'wolk-payment-gateway')),
				'type' => 'text',
				'label' => $this->_lang(__('Security Key', 'wolk-payment-gateway')),
				'default' => $this->_lang(__('Security Key', 'wolk-payment-gateway')),
				'description' => $this->_lang(__('You must request this information directly from your bank.', 'wolk-payment-gateway')),
			),
			'enable_minicuotas' => array(
				'title' => __('Habilitar MiniCuotas', 'wolk-payment-gateway'),
				'type' => 'checkbox',
				'label' => __('Activar MiniCuotas para diferentes plazos', 'wolk-payment-gateway'),
				'default' => 'no', // Por defecto deshabilitado
				'desc_tip' => true,
			),
			'enable_tasa0' => array(
				'title' => __('Habilitar Tasa 0', 'wolk-payment-gateway'),
				'type' => 'checkbox',
				'label' => __('Activar Tasa 0 para diferentes plazos', 'wolk-payment-gateway'),
				'default' => 'no', // Por defecto deshabilitado
				'desc_tip' => true,
			),

		);

		//! cambio a nivel de orden del codigo!!

		$additional_fields = $this->add_payment_methods_fields(); // Sin necesidad de pasar los valores como parametros
		$this->form_fields = array_merge($this->form_fields, $additional_fields);
	}

	// Funcion para agregar campos de minicuotas y Tasa 0
	public function add_payment_methods_fields()
	{
		$enable_minicuotas = $this->get_option('enable_minicuotas', 'no');
		$enable_tasa0 = $this->get_option('enable_tasa0', 'no');
		$plazos = array(12, 18, 24, 36);
		$currencies = array('USD', 'CRC'); // Monedas estandarizadas en mayusculas
		$fields = array();

		foreach ($currencies as $currency) {
			if ($enable_minicuotas === 'yes' || $enable_tasa0 === 'yes') {
				$fields[strtolower($currency) . '_title'] = array(
					'title' => __("Opciones en {$currency}", 'wolk-payment-gateway'),
					'type' => 'title',
				);
			}

			// MiniCuotas
			if ($enable_minicuotas === 'yes') {
				foreach ($plazos as $plazo) {
					$key = "minicuotas_{$currency}_{$plazo}";
					$fields[$key] = array(
						'title' => __("MiniCuotas - {$plazo} meses ({$currency})", 'wolk-payment-gateway'),
						'type' => 'text',
						'description' => __("Processor ID para MiniCuotas - {$plazo} meses en {$currency}."),
						'default' => '',
						'desc_tip' => true,
					);
				}
			}

			// Tasa 0
			if ($enable_tasa0 === 'yes') {
				foreach ($plazos as $plazo) {
					$key = "tasa0_{$currency}_{$plazo}";
					$fields[$key] = array(
						'title' => __("Tasa 0 - {$plazo} meses ({$currency})", 'wolk-payment-gateway'),
						'type' => 'text',
						'description' => __("Processor ID para Tasa 0 - {$plazo} meses en {$currency}."),
						'default' => '',
						'desc_tip' => true,
					);
				}
			}
		}

		return $fields;
	}



	/**
	 * Admin Panel Options
	 * - Options for bits like 'title' and availability on a country-by-country basis
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function admin_options()
	{


		$WolkLicenseAuth = new WolkLicenseAuth();
		$VerifyLicense = $WolkLicenseAuth->VerifyLicense();
		if ($VerifyLicense['status'] == 400) {
			require 'templates/auth-views/license-not-exist.php';
			exit();
		}

		if (isset($_GET['show_logs'])) {
			require 'templates/logs/logs.php';
			exit();
		}
		?>


		<div class="wolk-setting-heading">
			<img width="45px" src="<?php echo esc_url(plugins_url('', __FILE__) . '/assets/logo.png') ?>" />
			<h3><?php esc_html_e('Wolk Payment Settings', 'wolk-payment-gateway'); ?></h3>
			<a class="view_logs" href="#" onclick="view_logs()">View Logs</a>

		</div>
		<div id="poststuff">
			<div id="post-body" class="metabox-holder columns-2">
				<div id="post-body-content">
					<table class="form-table">
						<?php $this->generate_settings_html(); ?>
					</table><!--/.form-table-->
				</div>
				<div id="postbox-container-1" class="postbox-container">
					<div id="side-sortables" class="meta-box-sortables ui-sortable">

						<div class="postbox ">
							<h3 class="hndle"><span><i class="dashicons dashicons-update"></i>&nbsp;&nbsp;Your License
									Details</span></h3>
							<hr>
							<div class="inside">
								<div class="support-widget">
									<ul>
										<li><strong>Contrato # ></strong>
											<?php echo $VerifyLicense['status'] == 200 ? esc_html($VerifyLicense['# Contrato']) : "" ?>
										</li>
										<li><strong>Ciclo Cobro ></strong>
											<?php echo $VerifyLicense['status'] == 200 ? esc_html($VerifyLicense['Ciclo Cobro']) : "" ?>
										</li>
										<li><strong>Fin Contrato ></strong>
											<?php echo $VerifyLicense['status'] == 200 ? esc_html($VerifyLicense['Fin Contrato']) : "" ?>
										</li>
										<li><strong>Licencia ></strong>
											<?php

											if ($VerifyLicense['status'] == 200) {
												if ($VerifyLicense['Activo'] == 1) {
													echo '<span class="text-success" style="color:green">Activo</span>';
												} else {
													echo '<span class="text-danger" style="color:red">Inactivo</span>';
												}
											} else {
												echo '<span class="text-danger" style="color:red">Inactivo</span>';
											}

											?>
										</li>

									</ul>
								</div>
							</div>
						</div>
						<div class="postbox ">
							<h3 class="hndle"><span><i class="dashicons dashicons-editor-help"></i>&nbsp;&nbsp;Plugin
									Support</span></h3>
							<hr>
							<div class="inside">
								<div class="support-widget">
									<p>
										<img style="width: 70%;margin: 0 auto;position: relative;display: inherit;"
											src="<?php echo esc_url(plugins_url('', __FILE__) . '/assets/logo-1.png'); ?>">

										<br />
										<?php echo esc_html($this->_lang('license_inactive_inquiry_text')) ?>
									</p>
									<ul>
										<li>> Email at <a target="_blank"
												href="mailto:<?php echo esc_attr($this->_lang('license_inactive_inquiry_email')); ?>"><?php echo esc_html($this->_lang('license_inactive_inquiry_email')); ?></a>
										</li>
									</ul>

								</div>
							</div>
						</div>



					</div>
				</div>
			</div>
		</div>
		<div class="clear"></div>
		<style type="text/css">
			.wolk_button {
				background-color: #4CAF50 !important;
				border-color: #4CAF50 !important;
				color: #ffffff !important;
				width: 100%;
				text-align: center;
				height: 35px !important;
				font-size: 12pt !important;
			}

			.wolk_button .dashicons {
				padding-top: 5px;
			}
		</style>
		<script>
			function view_logs() {
				let originalURL = window.location.href + "&show_logs=1"
				window.location = originalURL
			}
		</script>

		<?php
	}

	//validate_settings_fields

	public function process_admin_options()
	{
		$this->init_settings();
		$post_data = $this->get_post_data();

		$WolkLicenseAuth = new WolkLicenseAuth();
		$VerifyLicense = $WolkLicenseAuth->VerifyLicense();

		if ($VerifyLicense['status'] == 400) {
			$this->add_error($this->_lang(__('license_inactive_on_form_msg')));
			$this->display_errors();
		} else {

			foreach ($this->get_form_fields() as $key => $field) {
				//$this->settings['title'] = '3D Secure - Wolk Payment';  si el problema persiste descomentar 
				if ('title' !== $this->get_field_type($field)) {
					try {

						$this->settings[$key] = $this->get_field_value($key, $field, $post_data);
					} catch (Exception $e) {
						$this->add_error($e->getMessage());
					}
				}
			}

			$this->display_errors();
			return update_option($this->get_option_key(), apply_filters('woocommerce_settings_api_sanitized_fields_' . $this->id, $this->settings), 'yes');
		}


	}



	public function validate_fields()
	{
		if ($this->text_box_required === 'no') {
			return true;
		}

		return true;
	}

	/**
 * Process the payment and return the result
 * Este es el metodo que WooCommerce llama cuando el usuario hace click en "Place Order"
 * 
 * @param int $order_id
 * @return array
 */
public function process_payment( $order_id ) {
    global $woocommerce;
    
    // Obtener la orden
    $order = wc_get_order( $order_id );
    
    if ( ! $order ) {
        wc_add_notice( 'Error: No se pudo obtener la orden.', 'error' );
        return array(
            'result'   => 'fail',
            'messages' => 'Error procesando la orden'
        );
    }
    
    // LOG para debug
    error_log('WOLK: process_payment iniciado para order_id: ' . $order_id);
    
    // NO reducir stock aun - se hace DESPUES de pago confirmado en wolk_complete_order()
    
    // ==============================================================
    // IMPORTANTE (POLITICA DE ESTADOS)
    // --------------------------------------------------------------
    // El usuario pidio que **NO** se cambie el estado de WooCommerce
    // durante el inicio del checkout / redireccion.
    //
    // [OK] El UNICO lugar autorizado para cambiar el estado de la orden
    // sera la funcion `wolk_complete_order()` (wolk-payment-gateway.php)
    // y SOLO despues de que el banco confirme `response=1` (APROBADO).
    //
    // Por eso, este update_status se deja comentado.
    // ==============================================================
    // $order->update_status(
    //     $this->order_status,
    //     __( 'Cliente siendo redirigido a la pagina de pago 3DS Secure', 'wolk-payment-gateway' )
    // );
    
    // NO vaciar el carrito aqui
    // Se vacia DESPUES de que el pago sea completado exitosamente
    // en wolk_complete_order() en wolk-payment-gateway.php
    
    // CONSTRUIR LA URL DE REDIRECCION A LA PAGINA DE PAGO
    // Esta es la URL a tu pagina custom "payment-process.php"
    $page_id = get_option('wolk_wc_payment_page_id');
    
    if ( ! $page_id ) {
        error_log('WOLK ERROR: No se encontro wolk_wc_payment_page_id');
        wc_add_notice( 'Error: Pagina de pago no configurada.', 'error' );
        return array(
            'result'   => 'fail',
            'messages' => 'Error en configuracion del gateway'
        );
    }
    
    // Construir URL con los parametros necesarios
    $redirect_url = add_query_arg( 'order', $order_id, get_permalink( $page_id ) );
    
    error_log('WOLK: Redirigiendo a: ' . $redirect_url);
    
    // Retornar el array que WooCommerce espera
    // 'result' => 'success' indica que debe redirigir
    // 'redirect' => URL a donde redirigir
    return array(
        'result'   => 'success',
        'redirect' => $redirect_url
    );
}

	public function payment_fields()
	{
		if ($this->description) {
			// you can instructions for test mode, I mean test card numbers etc.
			// display the description with <p> tags etc.
			echo esc_html((wp_kses_post($this->description)));
		}

	}

	public function get_order_status()
	{
		return $this->order_status;
	}
	public function get_id()
	{
		return $this->id;
	}
	public function get_currency_symbol()
	{
		return $this->currency_symbol;
	}
	public function get_brand_color()
	{
		return $this->brand_color;
	}

	public function _lang($text)
	{
		include 'lang.php';

		$sys_lang = $this->get_option('lang');

		if (empty($sys_lang)) {
			return $text;
		} else if ($sys_lang == 'en') {
			if (isset($lang['en'][$text])) {
				return $lang['en'][$text];
			} else {
				return $text;
			}
		} else if ($sys_lang == 'es') {
			if (isset($lang['es'][$text])) {
				return $lang['es'][$text];
			} else {
				return $text;
			}
		}
	}


	function encrypt_decrypt($action, $string, $secret_iv, $secret_key)
	{
		$output = false;
		$encrypt_method = "AES-256-CBC";
		// hash
		$key = hash('sha256', $secret_key);

		// iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
		$iv = substr(hash('sha256', $secret_iv), 0, 16);
		if ($action == 'encrypt') {
			$output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
			$output = base64_encode($output);
		} else if ($action == 'decrypt') {
			$output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
		}
		return $output;
	}

	function get_custom_logo_url()
	{
		$custom_logo_id = get_theme_mod('custom_logo');
		$image = wp_get_attachment_image_src($custom_logo_id, 'full');
		if ($image) {
			return $image[0];
		}
		return plugin_dir_url(__FILE__) . "assets/logo-1.png";

	}
}



