<?php 
    if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 
    require plugin_dir_path(__DIR__).'/../lang.php';
    $sys_lang = $this->get_option('lang');
?>
<style>
    .yith-ywot-empty-state-container {
        border: 1px solid #ddd;
        border-top: 0;
        position: absolute;
        width: calc(100% - 82px);
        background: #fff;
        z-index: 100;
        padding: 20px;
    }

    /* .yith-ywot-cta-container {
        position: relative;
        top: 35%;
        transform: translateY(-40%);
    } */

    .yith-plugin-fw__list-table-blank-state {
        text-align: center;
        display: flex;
        gap: 3rem;
        margin-top: 3rem;
        /* flex-direction: column; */
    }

    .yith-plugin-fw__list-table-blank-state>div{
        width: 49%;
    }
    .in_active_heading{
        text-align: center;
        color: #b22d2d;
        font-size: 1.6rem;
    }
    .in_active_desc{
        line-height: 23px;
        text-align: center;
        color: #1d1d1d;
        font-size: 1rem;
        padding: 0px 1.2rem;
        font-weight: 400;
    }

    .in_active_payment_button_box{
        padding: 2em 6em;
    }
    .yith-plugin-fw__list-table-blank-state .package-image{
        width: 100%;
    }

    .yith-plugin-fw__list-table-blank-state img.yith-plugin-fw__list-table-blank-state__icon {
        width: 100px;
        margin: 0 auto 30px;
    }
    .yith-plugin-fw__list-table-blank-state__message{
        font-size: 1.2em;
        font-weight: 600;
        color: #a33219;
    }
    .yith-plugin-fw__list-table-blank-state__message_or{
        color: #212223;
        font-size: 2.3em;
        line-height: 1.3;
        font-weight: 500;
        text-align: center;
        margin-top: 30px;
        margin-bottom: 30px;
    }

    .wolk-seperator {
        width: 100%;
        border: 1px solid #eeeeee;
    }
    

    /* my */
     .landing__head {
        font-size: 1.8em;
        font-weight: 600;
        color: #A36A19;
        text-align: center;
        margin-top: 20px;
        margin-bottom: 20px;
    }
     .landing__pricing {
        font-size: 2.3em;
        line-height: 1.3;
        font-weight: 500;
        text-align: center;
        margin: 1.5rem 1rem;
    }

    .__cta_div{
        justify-content: center;
        align-items: center;
        width: 100%;
        display: flex;
    }
    .landing__cta {
        display: block;
        width: 275px;
        padding: 8px 12px;
        font-size: 1.2em;
        font-weight: 600;
        background-color: #D4922D;
        color: #fff;
        text-align: center;
        text-transform: uppercase;
        text-decoration: none;
        border-radius: 5px;
        transition: .3s;
        margin: 32px 0;
    }

    ._license_container{
        display: flex;
        justify-content: center;
        margin-top: 30px;
    }

    ._license_container ._license_input{

        letter-spacing: 5px;
        width: 45%;
        padding: 5px 10px;
        font-size: 1.2em;
        font-weight: 500;
        border: 1px solid #cbd5e1;
        height: 40px;
        min-width: 90px;
        box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    }
    ._license_container ._license_button{
        border: 0px;
        background: green;
        color: white;
        font-size: 1.1em;
        border-radius: 4px;
        margin-left: 5px;
        padding: 10px 14px;
        cursor: pointer;
    }
    ._license_container ._license_button:hover{
        background: darkgreen;
    }
    ._license_container ._license_button:disabled{
        background: gray;
    }

    .landing__container{
        
    }
    .landing__advantages{
        margin-top: 15px;
    }

    ._license_response_msg{
        font-size: 1.2em;
        font-weight: 400;
        color: #c83838;
        margin-top: 10px;
    }
    .inquiry-text{
        text-align: center;
        padding: 2rem 4rem;
    }

    @media (max-width: 782px){
        .yith-plugin-fw__list-table-blank-state{
            display: block;
        }
        .yith-plugin-fw__list-table-blank-state>div{
            width: 100%;
        }
    }

    .stripe-button{
        width: 100%;
        display: flex;
        color: white;
        background: #6273e9;
        text-decoration: none;
        text-align: center;
        align-items: center;
        padding: 6px;
        border-radius: 10px;
        font-size: 20px;
        /* text-align: center; */
        justify-content: center;
        position: relative;
        height: 34px;
    }
    .stripe-button:hover{
        text-decoration: underline;
        color: white;
    }
   /* Custom Styles for the Stripe Button */

    .stripe-button img {
        height: 24px;
        margin-right: 10px;
        position: absolute;
        left: 6px;
    }
</style>


<div class="yith-ywot-empty-state-container">
    <div class="wolk-setting-heading">
        
        <img width="45px" src="<?php echo esc_html(esc_url(plugins_url('/../../assets/logo.png', __FILE__))) ?>" />
        <h3>
            <?php esc_html_e('Wolk Payment Settings', 'wolk-payment-gateway'); ?>
        </h3>
    </div>
    <div class="yith-ywot-cta-container">
        <h3 class="in_active_heading"><?php echo esc_html($this->_lang('license_inactive_heading')) ?> !!!</h3>
        <h3 class="in_active_desc"><?php echo esc_html($this->_lang('license_inactive_desc')) ?></h3>
        <div id="" class="yith-plugin-fw__list-table-blank-state ">
            <!--  -->
            <div>
                <div>
                    <div class="landing__pricing">
                        <div class="product-price-del">
                            <span class="woocommerce-Price-amount amount"><span
                                    class="woocommerce-Price-currencySymbol"><span
                                        class="currency-symbol">$</span><span></span>&nbsp;75</span><span
                                    class="decimals">.00</span></span><span class="recurring-label">/ 1 <?php echo esc_html($this->_lang('year')) ?></span>
                        </div>
                    </div>
                </div>
                <div>
                    <img class="package-image" src="<?php echo esc_url(plugins_url('/../../assets/75-dollar.png', __FILE__)) ?>" />
                </div>
                <div class="in_active_payment_button_box">
                    <a href="https://buy.stripe.com/5kA3dS5Nz8rv5Pi145" class="stripe-button" target="_blank">
                        <img src="<?php echo esc_url(plugins_url('/../../assets/stripe.png', __FILE__)) ?>" alt="Stripe Logo">
                        Pay Now
                    </a>
                    <!-- <div id="paypal-button-container-P-9JY79972WH1374115MVA2JPY"></div> -->
                </div>
            </div>
            <!--  -->
            <div>
                <div>
                    <div class="landing__pricing">
                        <div class="product-price-del">
                            <span class="woocommerce-Price-amount amount"><span
                                    class="woocommerce-Price-currencySymbol"><span
                                        class="currency-symbol">$</span><span></span>&nbsp;100</span><span
                                    class="decimals">.00</span></span><span class="recurring-label">/ 2 <?php echo esc_html($this->_lang('year')) ?></span>
                        </div>
                    </div>
                </div>
                <div>
                    <img class="package-image" src="<?php echo esc_url(plugins_url('/../../assets/100-dollar.png', __FILE__)) ?>" />
                </div>
                <div class="in_active_payment_button_box">
                    <a href="https://buy.stripe.com/aEU3dS7VH8rv0uY5km" class="stripe-button" target="_blank">
                        <img src="<?php echo esc_url(plugins_url('/../../assets/stripe.png', __FILE__)) ?>" alt="Stripe Logo">
                        Pay Now
                    </a>
                    <!-- <div id="paypal-button-container-P-5EV439973K7530537MVA2NRY"></div> -->
                </div>
            </div>
        
        </div>

        <div>
        
            <div class="inquiry-text">
                <?php echo esc_html($this->_lang('license_inactive_inquiry_text')) ?>
                <br />
                <strong><?php echo esc_html($this->_lang('license_inactive_inquiry_email')) ?></strong>
            </div>
           
        </div>
    </div>
</div>


<script>
  paypal.Buttons({
      style: {
          shape: 'rect',
          color: 'gold',
          layout: 'vertical',
          label: 'subscribe'
      },
      createSubscription: function(data, actions) {
        return actions.subscription.create({
          /* Creates the subscription */
          plan_id: 'P-9JY79972WH1374115MVA2JPY'
        });
      },
      onApprove: function(data, actions) {
        alert(data.subscriptionID); // You can add optional success message for the subscriber here
      }
  }).render('#paypal-button-container-P-9JY79972WH1374115MVA2JPY'); // Renders the PayPal button
</script>
<script>
  paypal.Buttons({
      style: {
          shape: 'rect',
          color: 'gold',
          layout: 'vertical',
          label: 'subscribe'
      },
      createSubscription: function(data, actions) {
        return actions.subscription.create({
          /* Creates the subscription */
          plan_id: 'P-5EV439973K7530537MVA2NRY'
        });
      },
      onApprove: function(data, actions) {
        alert(data.subscriptionID); // You can add optional success message for the subscriber here
      }
  }).render('#paypal-button-container-P-5EV439973K7530537MVA2NRY'); // Renders the PayPal button
</script>

<script>
   
    let langu = '<?php echo wp_json_encode($lang,true) ?>' ;
    let sys_lang = '<?php echo esc_html($sys_lang) ?>';
    jQuery(document).ready(function($) {
    
        Swal.fire(
                             _lang('activated_swal_text')+'!',
                             _lang('desc_swal_text'),
                                'success'
                            )
        $('#license-submit').click(function(){
           let license_key =  $('#license-input').val()
           $('#license-submit').attr('disabled',true)
           if(license_key == ""){
                $('#license-input').focus()
           }else{
                var _data ={ 
                    'action' : 'wolk_submit_activate_license',
                    'license_key' : license_key,
                }
                $.ajax({
                    url : "<?php echo esc_url(admin_url( 'admin-ajax.php' )); ?>",
                    method : 'POST',
                    data : _data,
                    success :function(res){
                        res = JSON.parse(res)
                        console.log(res)
                        if(res.status == 200){
                           // window.reload()
                           Swal.fire(
                             _lang('activated_swal_text')+'!',
                             _lang('desc_swal_text'),
                                'success'
                            )
                        }
                        if(res.status == 400){
                           $('._license_response_msg').text(res.msg)
                           $('#license-input').focus()
                        }
                        $('#license-submit').attr('disabled',false)
                    }
                })
           }
        })
    })

    function _lang(text){
        let l =  langu
        let lang = JSON.parse(l);
        if(!sys_lang){
			return text;
		}
		else if(sys_lang == 'en'){
            if((text in lang['en'])){
				return lang['en'][text];
			}else{
				return text;
			}
		}
		else if(sys_lang == 'es'){
			if((text in lang['es'])){
				return lang['es'][text];
			}else{
				return text;
			}
		}
    }  
</script>