<?php  if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>
<?php 
    require plugin_dir_path(__DIR__).'/../lang.php';
    $sys_lang = $this->get_option('lang');
?>
<style>
    .yith-ywot-empty-state-container {
        border: 1px solid #ddd;
        border-top: 0;
        background: #fff;
        z-index: 100;
        padding: 20px;
    }

    /* .yith-ywot-cta-container {
        position: relative;
        top: 35%;
        transform: translateY(-40%);
    } */

    .yith-plugin-fw__list-table-blank-state {
        text-align: center;
        display: flex;
        gap: 3rem;
        margin-top: 3rem;
        /* flex-direction: column; */
    }

    .yith-plugin-fw__list-table-blank-state>div{
        width: 49%;
    }
    .in_active_heading{
        text-align: center;
        color: #b22d2d;
        font-size: 1.6rem;
    }
    .in_active_desc{
        line-height: 23px;
        text-align: center;
        color: #1d1d1d;
        font-size: 1rem;
        padding: 0px 1.2rem;
        font-weight: 400;
    }

    .in_active_payment_button_box{
        padding: 2em 6em;
    }
    .yith-plugin-fw__list-table-blank-state .package-image{
        width: 100%;
    }

    .yith-plugin-fw__list-table-blank-state img.yith-plugin-fw__list-table-blank-state__icon {
        width: 100px;
        margin: 0 auto 30px;
    }
    .yith-plugin-fw__list-table-blank-state__message{
        font-size: 1.2em;
        font-weight: 600;
        color: #a33219;
    }
    .yith-plugin-fw__list-table-blank-state__message_or{
        color: #212223;
        font-size: 2.3em;
        line-height: 1.3;
        font-weight: 500;
        text-align: center;
        margin-top: 30px;
        margin-bottom: 30px;
    }

    .wolk-seperator {
        width: 100%;
        border: 1px solid #eeeeee;
    }
    

    /* my */
     .landing__head {
        font-size: 1.8em;
        font-weight: 600;
        color: #A36A19;
        text-align: center;
        margin-top: 20px;
        margin-bottom: 20px;
    }
     .landing__pricing {
        font-size: 2.3em;
        line-height: 1.3;
        font-weight: 500;
        text-align: center;
        margin: 1.5rem 1rem;
    }

    .__cta_div{
        justify-content: center;
        align-items: center;
        width: 100%;
        display: flex;
    }
    .landing__cta {
        display: block;
        width: 275px;
        padding: 8px 12px;
        font-size: 1.2em;
        font-weight: 600;
        background-color: #D4922D;
        color: #fff;
        text-align: center;
        text-transform: uppercase;
        text-decoration: none;
        border-radius: 5px;
        transition: .3s;
        margin: 32px 0;
    }

    ._license_container{
        display: flex;
        justify-content: center;
        margin-top: 30px;
    }

    ._license_container ._license_input{

        letter-spacing: 5px;
        width: 45%;
        padding: 5px 10px;
        font-size: 1.2em;
        font-weight: 500;
        border: 1px solid #cbd5e1;
        height: 40px;
        min-width: 90px;
        box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
    }
    ._license_container ._license_button{
        border: 0px;
        background: green;
        color: white;
        font-size: 1.1em;
        border-radius: 4px;
        margin-left: 5px;
        padding: 10px 14px;
        cursor: pointer;
    }
    ._license_container ._license_button:hover{
        background: darkgreen;
    }
    ._license_container ._license_button:disabled{
        background: gray;
    }

    .landing__container{
        
    }
    .landing__advantages{
        margin-top: 15px;
    }

    ._license_response_msg{
        font-size: 1.2em;
        font-weight: 400;
        color: #c83838;
        margin-top: 10px;
    }
    .inquiry-text{
        text-align: center;
        padding: 2rem 4rem;
    }

    @media (max-width: 782px){
        .yith-plugin-fw__list-table-blank-state{
            display: block;
        }
        .yith-plugin-fw__list-table-blank-state>div{
            width: 100%;
        }
    }
    .wolk-setting-heading{
        display: flex;
        gap: 15px;
        align-items: center;
    }
</style>


<div class="yith-ywot-empty-state-container">
    <div class="wolk-setting-heading">
        
        <img width="45px" src="<?php echo esc_url(plugins_url('', __FILE__).'/../../assets/logo.png') ?>" />
        <h3>
            <?php esc_html_e('Wolk Payment Settings', 'wolk-payment-gateway'); ?>
        </h3>

        <a class="go-back" href="#">Go Back</a>
    </div>
    <div class="yith-ywot-cta-container" style="margin-top:30px">
    <table id="table" class="stripe cell-border" width="100%" >
        <thead>
            <tr role="row">
                <th width="8%">Order ID</th>
                <th  width="12%">CC Last 6 digit</th>
                <th  width="10%">Card Holder</th>
                <th  width="40%">Error Details</th>
                <th  width="10%">Type</th>
                <th width="10%">Created At</th>
            </tr>
        </thead>
        <tbody></tbody>
    </table>
    </div>
</div>

<script>
    jQuery(document).ready(function($) {
    
            var jobtable = jQuery('#table').DataTable({
                ajax: {
                    url: '<?php echo esc_url(admin_url("admin-ajax.php") . "/?action=getpostsfordatatables"); ?>'
                },
                "ordering": false,
                "order":[[5, 'desc']],  
                "pageLength": 10,
                "processing":true,  
                "serverSide": true, 
    
            });

            
        $('.go-back').click(function(){
            let originalURL =  window.location.href
            var alteredURL = removeParam("show_logs", originalURL);
            window.location = alteredURL
        })

    });

    function removeParam(key, sourceURL) {
        var rtn = sourceURL.split("?")[0],
            param,
            params_arr = [],
            queryString = (sourceURL.indexOf("?") !== -1) ? sourceURL.split("?")[1] : "";
        if (queryString !== "") {
            params_arr = queryString.split("&");
            for (var i = params_arr.length - 1; i >= 0; i -= 1) {
                param = params_arr[i].split("=")[0];
                if (param === key) {
                    params_arr.splice(i, 1);
                }
            }
            if (params_arr.length) rtn = rtn + "?" + params_arr.join("&");
        }
        return rtn;
    }
</script>