<?php if (!defined('ABSPATH'))
	exit; // Exit if accessed directly ?>
<?php
// SEGURIDAD: Verificar conexion HTTPS en pagina de pago
if (!is_ssl() && !WP_DEBUG) {
    wp_die(
        esc_html__('Para su seguridad, los pagos solo se procesan a traves de conexiones seguras (HTTPS).', 'wolk-payment-gateway'),
        esc_html__('Conexion no segura', 'wolk-payment-gateway'),
        array('response' => 403, 'back_link' => true)
    );
}
?>
<?php get_header(); ?>
<?php

/* Template Name: Payment Process */

require plugin_dir_path(__DIR__) . 'lang.php';
$years = range(gmdate("Y", strtotime('+10 years')), gmdate("Y", strtotime('-5 years')));

global $post;
global $wpdb;
global $woocommerce;
$order_id = isset($_GET['order']) ? esc_html(sanitize_text_field($_GET['order'])) : '';
$order = wc_get_order($order_id);
$items = $order->get_items();
$currency_code = $order->get_currency();
$country = $order->get_billing_country();
$currency_symbol = get_woocommerce_currency_symbol($currency_code);
$customer_ip = get_customer_ip();

function get_customer_ip()
{
	$ipaddress = '';
	if (isset($_SERVER['HTTP_CLIENT_IP'])) {
		$ipaddress = $_SERVER['HTTP_CLIENT_IP'];
	} elseif (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} elseif (isset($_SERVER['HTTP_X_FORWARDED'])) {
		$ipaddress = $_SERVER['HTTP_X_FORWARDED'];
	} elseif (isset($_SERVER['HTTP_X_CLUSTER_CLIENT_IP'])) {
		$ipaddress = $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
	} elseif (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
		$ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
	} elseif (isset($_SERVER['HTTP_FORWARDED'])) {
		$ipaddress = $_SERVER['HTTP_FORWARDED'];
	} elseif (isset($_SERVER['REMOTE_ADDR'])) {
		$ipaddress = $_SERVER['REMOTE_ADDR'];
	} else {
		$ipaddress = 'UNKNOWN';
	}
	return $ipaddress;
}




if ($order == false) {
	wp_redirect(home_url());
	exit();
}

$Payment_Gateway = new Wolk_Payment_Gateway();
$public_key = $Payment_Gateway->get_option('public_key');
// SEGURIDAD PCI: security_key ya no se obtiene aqui - se maneja solo en backend
$sys_lang = $Payment_Gateway->get_option('lang');
$brand_color = $Payment_Gateway->get_option('brand_color');
$currency_symbol = $Payment_Gateway->get_option('currency_symbol');
$currency_symbol = get_woocommerce_currency_symbol($currency_symbol);

// Validar licencia antes de mostrar el formulario de pago
$WolkLicenseAuth = new WolkLicenseAuth();
$license_attempts = 0;
$max_license_attempts = 3;
$VerifyLicense = null;
$license_check_log = [];

// Intentar hasta 3 veces la verificacion de licencia
for ($i = 1; $i <= $max_license_attempts; $i++) {
    $license_attempts = $i;
    $VerifyLicense = $WolkLicenseAuth->VerifyLicense();
    error_log('WOLK DEBUG: VerifyLicense=' . print_r($VerifyLicense, true));
    if (isset($VerifyLicense['timeout']) && $VerifyLicense['timeout'] === true) {
        $license_check_log[] = "Intento $i: TIMEOUT";
        // Si es timeout, reintentar
        continue;
    } elseif ($VerifyLicense['status'] == 200 && isset($VerifyLicense['Activo']) && $VerifyLicense['Activo'] == 1) {
        $license_check_log[] = "Intento $i: ACTIVA";
        break;
    } elseif ($VerifyLicense['status'] == 400) {
        $license_check_log[] = "Intento $i: INACTIVA";
        break;
    } else {
        $license_check_log[] = "Intento $i: ERROR";
        break;
    }
}
$license_active = ($VerifyLicense['status'] == 200 && isset($VerifyLicense['Activo']) && $VerifyLicense['Activo'] == 1) || (isset($VerifyLicense['timeout']) && $VerifyLicense['timeout'] === true);
$license_timeout = (isset($VerifyLicense['timeout']) && $VerifyLicense['timeout'] === true);


$gateway_id = $Payment_Gateway->id;
$encrypted_processor_ids = get_processor_ids($gateway_id);

function get_processor_ids($gateway_id)
{
	$settings = get_option("woocommerce_{$gateway_id}_settings");
	$order_id = isset($_GET['order']) ? esc_html(sanitize_text_field($_GET['order'])) : '';
	$processor_ids = [];
	//nueva instancia de wolk payment gtway para acceder a los metodos encrypt decrypt :)
	$Payment_Gateway = new Wolk_Payment_Gateway();
	if (!$settings || !is_array($settings)) {
		error_log("No settings found for gateway ID: {$gateway_id}");
		return [];
	}



	// recorre $settings, obtiene key value & encripta 
	foreach ($settings as $key => $value) {
		if ((strpos($key, 'minicuotas_') === 0 || strpos($key, 'tasa0_') === 0) && ctype_digit($value)) {
			// encriptar processor ids
			$encrypted_value = $Payment_Gateway->encrypt_decrypt('encrypt', $value, 'order', $order_id);
			$processor_ids[$key] = $encrypted_value;
		}
	}

	if (empty($processor_ids)) {
		error_log("No Processor IDs found for gateway ID: {$gateway_id}");
	} else {
		error_log("Encrypted Processor IDs: " . print_r($processor_ids, true));
	}

	return $processor_ids;
}



//$your_gateway->your_setting;
// Get the meta data in an unprotected array
$order_data = $order->get_data();

$ccno = isset($_GET['ccno']) ? $Payment_Gateway->encrypt_decrypt('decrypt', esc_html(sanitize_text_field($_GET['ccno'])), 'order', $order_id) : '';
$exp_m = isset($_GET['exp_m']) ? $Payment_Gateway->encrypt_decrypt('decrypt', esc_html(sanitize_text_field($_GET['exp_m'])), 'order', $order_id) : '';
$exp_y = isset($_GET['exp_y']) ? $Payment_Gateway->encrypt_decrypt('decrypt', esc_html(sanitize_text_field($_GET['exp_y'])), 'order', $order_id) : '';
$cvv = isset($_GET['cvv']) ? $Payment_Gateway->encrypt_decrypt('decrypt', esc_html(sanitize_text_field($_GET['cvv'])), 'order', $order_id) : '';

$first_name = esc_html(sanitize_text_field($order_data['billing']['first_name']));
$last_name = esc_html(sanitize_text_field($order_data['billing']['last_name']));
$total = esc_html(sanitize_text_field($order_data['total']));

?>
<meta name="viewport" content="width=device-width, initial-scale=1">
<script>
    // Variable global para JS sobre el estado de la licencia
    var wolk_license_active = <?php echo $license_active ? 'true' : 'false'; ?>;
    var wolk_license_timeout = <?php echo $license_timeout ? 'true' : 'false'; ?>;
    var wolk_license_attempts = <?php echo (int)$license_attempts; ?>;
    var wolk_license_check_log = <?php echo json_encode($license_check_log); ?>;
    console.log('[WOLK] Estado de licencia:', wolk_license_active ? 'ACTIVA' : 'INACTIVA');
    console.log('[WOLK] Intentos de verificacion de licencia:', wolk_license_attempts);
    wolk_license_check_log.forEach(function(msg){ console.log('[WOLK] ' + msg); });
    if (wolk_license_timeout) {
        console.warn('[WOLK] Timeout al validar la licencia. Se permite el pago temporalmente.');
    }
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://songbirdstag.cardinalcommerce.com/cardinalcruise/v1/songbird.js"></script>
<script>
	let public_key = '<?php echo esc_js($public_key); ?>';
	// SEGURIDAD PCI: security_key REMOVIDA - nunca exponer al cliente
	// La security_key se maneja exclusivamente en el backend
	let ccno = '<?php echo esc_js($ccno); ?>';
	let exp_m = '<?php echo esc_js($exp_m); ?>';
	let exp_y = '<?php echo esc_js($exp_y); ?>';
	let cvv = '<?php echo esc_js($cvv); ?>';
	let total = '<?php echo esc_js($total); ?>';
	let langu = <?php echo wp_json_encode($lang); ?>;
	let order_id = '<?php echo esc_js($order_id); ?>';
	let sys_lang = '<?php echo esc_js($sys_lang); ?>';
	let currency_code = '<?php echo esc_js($currency_code); ?>';
	let country = '<?php echo esc_js($country); ?>';

</script>

<div id="wolk-payment-wrapper">
	<div id="wolk-payment-container">
        <iframe height="10" width="10" style="visibility: hidden; position: absolute; top: -1000px; left: -1000px;"></iframe>
        <form id="collectionForm" name="devicedata" method="POST" action="https://centinelapistag.cardinalcommerce.com/V2/Cruise/Collect">
            <!-- POST Parameters: is the JWT which is the Authentication JWT with the ReferenceId from the Data Exchange API Response -->
            <input type="hidden" name="JWT" value="Authentication JWT generated per specification" />
        </form>
       <!-- <script>window.onload = function () {
                // Auto submit form on page load
                document.getElementById('collectionForm').submit();
            }
        </script> -->
        <div id="left-col" style="
			background :  <?php echo esc_html($brand_color) ?>
		">
			<div id="left-col-cont">
				<h2><?php echo esc_html($Payment_Gateway->_lang('Summary')) ?></h2>
				<div class="items-list">
					<?php
					foreach ($order->get_items() as $item_id => $item) {
						$product = $item->get_product();
						$thumbnail = $product->get_image(array(60, 60));
						$product_name = $item->get_name();
						$item_quantity = $item->get_quantity();
						$item_total = $item->get_total();
						?>
						<div class="item">
							<div class="img-col">
								<?php echo wp_kses_post($product->get_image(array(60, 60))); ?>
							</div>
							<div class="meta-col">
								<h3><?php echo esc_html($product_name); ?></h3>
								<p class="price">x<?php echo esc_html($item_quantity); ?></p>
								<p class="price"><?php echo wc_price($item_total); ?></p>

							</div>
						</div>

						<?php


					}
					?>
				</div>
				<p id="total"><?php echo esc_html($Payment_Gateway->_lang('Total')) ?></p>
				<h4 id="total-price"><?php echo wc_price($total); ?></h4>
			</div>
		</div>
		<div id="right-col">
			<h2><?php echo esc_html($Payment_Gateway->_lang('Payment')) ?></h2>
			<div id="logotype">
				<img id="mastercard" src="<?php echo esc_html($Payment_Gateway->get_custom_logo_url()) ?>" alt="" />
			</div>

<?php if (!$license_active): ?>
    <div class="form-error" style="color:#fff; background:rgba(211,47,47,0.0); border-radius:10px; font-size:1.2em; text-align:center; margin:2em 0; padding:2em 1em; max-width:500px; margin-left:auto; margin-right:auto;">
        <i class="fas fa-exclamation-triangle" style="font-size:2em; margin-bottom:0.5em; color:#d32f2f;"></i><br>
        <span style="font-weight:bold; font-size:1.1em; display:block; margin-bottom:0.5em; color:#d32f2f;">
            <?php 
            $msg = $Payment_Gateway->_lang('error_7777B');
            $lang_opt = $Payment_Gateway->get_option('lang');
            if ($msg === 'error_7777B') {
                if ($lang_opt === 'en') {
                    echo 'Error 7777B: Please contact the merchant regarding this error.';
                } else {
                    echo 'Error 7777B: Comuniquese con el comercio con respecto a este error.';
                }
            } else {
                echo esc_html($msg);
            }
            ?>
        </span>
    </div>
<?php elseif ($license_timeout): ?>
    <div class="form-error" style="color:orange; font-size:1.2em; text-align:center; margin:2em 0;">
        <?php echo esc_html($Payment_Gateway->_lang('license_timeout')); ?>
    </div>
<?php else: ?>
			<form action="javascript:;" id="request-payment">
				<input type="hidden" id="customer_ip" value="<?php echo esc_html($customer_ip) ?>">
				<div style="display:inline-flex;gap:10px;width: 100%;">
					<div>
						<label for=""><?php echo esc_html($Payment_Gateway->_lang('First Name')) ?> <i
								class="fas fa-user"></i></label>
						<input id="wolk_first_name" type="text" placeholder="First Name"
							value="<?php echo esc_html($first_name) ?>" />
						<div class="first_name-error"></div>
					</div>
					<div>
						<label for=""><?php echo esc_html($Payment_Gateway->_lang('Last Name')) ?> <i
								class="fas fa-user"></i></label>
						<input id="wolk_last_name" type="text" placeholder="Last Name"
							value="<?php echo esc_html($last_name) ?>" />
						<div class="last_name-error"></div>
					</div>
				</div>

				<label for="wolk_ccNo"><?php echo esc_html($Payment_Gateway->_lang('Card Number')) ?> <i
						class="fas fa-credit-card"></i></label>
				<input type="tel" id="wolk_ccNo" name="wolk_ccNo" placeholder="1234 5678 9012 3456" maxlength="19">
				<div class="card-error"></div>


				<label for=""><?php echo esc_html($Payment_Gateway->_lang('Card Holder')) ?> <i
						class="fas fa-id-card"></i></label>
				<input id="wolk_cardholder" type="text" placeholder="Nombre Apellidos" value="" />
				<div class="holder-error"></div>

				<label for=""><?php echo esc_html($Payment_Gateway->_lang('Email')) ?> <i
						class="fas fa-envelope"></i></label>
				<input id="wolk_email" type="text" placeholder="correo@email.com" value="" />
				<div class="email-error"></div>

				<div class="left">
					<label for=""><?php echo esc_html($Payment_Gateway->_lang('Expiry Date')) ?> <i
							class="fas fa-calendar-alt"></i></label>
					<div class="d-flex" style="display:flex;gap:10px">
						<select name="month" id="wolk_month" onchange="" size="1">
							<option value="00"><?php echo esc_html($Payment_Gateway->_lang('Month')) ?></option>
							<option value="01"><?php echo esc_html($Payment_Gateway->_lang('January')) ?></option>
							<option value="02"><?php echo esc_html($Payment_Gateway->_lang('February')) ?></option>
							<option value="03"><?php echo esc_html($Payment_Gateway->_lang('March')) ?></option>
							<option value="04"><?php echo esc_html($Payment_Gateway->_lang('April')) ?></option>
							<option value="05"><?php echo esc_html($Payment_Gateway->_lang('May')) ?></option>
							<option value="06"><?php echo esc_html($Payment_Gateway->_lang('June')) ?></option>
							<option value="07"><?php echo esc_html($Payment_Gateway->_lang('July')) ?></option>
							<option value="08"><?php echo esc_html($Payment_Gateway->_lang('August')) ?></option>
							<option value="09"><?php echo esc_html($Payment_Gateway->_lang('September')) ?></option>
							<option value="10"><?php echo esc_html($Payment_Gateway->_lang('October')) ?></option>
							<option value="11"><?php echo esc_html($Payment_Gateway->_lang('November')) ?></option>
							<option value="12"><?php echo esc_html($Payment_Gateway->_lang('December')) ?></option>
							<!-- Resto de opciones... -->
						</select>
						<select name="year" id="wolk_year" onchange="" size="1">
							<option value="00"><?php echo esc_html($Payment_Gateway->_lang('Year')) ?></option>
							<?php
							foreach ($years as $year) {
								$value = substr($year, 2);
								?>
								<option value="<?php echo esc_html($value) ?>"><?php echo esc_html($year) ?></option>
							<?php }
							?>

						</select>


					</div>

					<div class="expiry-error"></div>
				</div>

				<div class="right">
					<label id="cvc-label" for="">CVC <i class="fas fa-lock"></i></label>
					<input id="wolk_cvc" class="cvc" type="number" placeholder="123" maxlength="4" />
					<div class="cvc-error"></div>
				</div>
				<div class="form-error"></div>
				<?php
				// Debug

				error_log('Processor IDs: ' . print_r($encrypted_processor_ids, true));

				// Obtener la moneda current
				$current_currency = get_woocommerce_currency();
                error_log('Current Currency: ' . $current_currency);
				// Obtener los processor_ids
				$Payment_Gateway = new Wolk_Payment_Gateway();
				$encrypted_processor_ids = get_processor_ids($gateway_id);
							
				$isMinicuotas = $Payment_Gateway->get_option('enable_minicuotas') === 'yes';
				$isTasa0 = $Payment_Gateway->get_option('enable_tasa0') === 'yes';
				// No filtrar por moneda
				$available_processors = $encrypted_processor_ids;

				// Verificar si hay processor_ids disponibles
				if (!empty($available_processors) && ($isMinicuotas || $isTasa0)) {
					?>
					<div class="form-group">
						<label for="installment-plan"><?php echo esc_html($Payment_Gateway->_lang('Seleccione el plan de pago:')); ?></label>
						<select name="installment_plan" id="installment-plan" class="form-control"
							style="width: 100%; display: flex; gap: 10px; margin-bottom: 10px;">
							<option value=""><?php echo esc_html($Payment_Gateway->_lang('Seleccione un plan')); ?></option>
							<option value="single_payment"><?php echo esc_html($Payment_Gateway->_lang('Pago unico')); ?></option>
							<?php
							foreach ($available_processors as $key => $value) {
								if (!empty($value)) {
									$parts = explode('_', $key);
									$tipo = $parts[0]; // minicuotas o tasa0
									$plazo = $parts[2]; // 12, 18, 24, etc.
									$moneda = strtoupper($parts[1]); // USD o CRC

									// Verificar cada tipo por separado
									if ($tipo === 'minicuotas' && $isMinicuotas) {
										?>
										<option value="<?php echo esc_attr($value); ?>">
											<?php echo esc_html(ucfirst($tipo) . ' - ' . $plazo . ' meses (' . $moneda . ')'); ?>
										</option>
										<?php
									} elseif ($tipo === 'tasa0' && $isTasa0) {
										?>
										<option value="<?php echo esc_attr($value); ?>">
											<?php echo esc_html(ucfirst($tipo) . ' - ' . $plazo . ' meses (' . $moneda . ')'); ?>
										</option>
										<?php
									}
								}
							}
							?>
						</select>
					</div>
					<?php
				} else {
					// Si no hay planes de cuotas disponibles, mostrar solo la opcion de pago unico
					?>
					<input type="hidden" id="installment-plan" value="single_payment">
					<?php
				}

				
				?>
				<button type="submit" id="purchase" style=" margin-bottom: 10px;
						background : <?php echo esc_html($brand_color); ?>
					"><i class="fas fa-shopping-cart"></i> <?php echo esc_html($Payment_Gateway->_lang('Purchase')) ?></button>
			</form>
<?php endif; ?>
		</div>
	</div>
</div>
<authBox>
	<modal>
		<div id="detail-content">
			<div id="loader">
				<?php
				include plugin_dir_path(__DIR__) . 'assets/loader.svg'
					?>
			</div>
			<div>
				<div id="responseIcon" class="wolk-response-icon" aria-hidden="true" style="display:none;"></div>
				<h1 id="responseTitle" style="text-align:center; font-size:3em;margin-top:10px"></h1>
				<p style="text-align:center; font-size:1.5em; margin-top:10px;padding:7px 35px" id="response"></p>
			</div>
		</div>

		<div class="button-container">
			<button id="close-modal"><?php echo esc_html($Payment_Gateway->_lang('Close')) ?> </button>
		</div>
	</modal>
</authBox>

<!-- TOGGLE RESUMEN COLAPSIBLE - Mobile only -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    var leftCol = document.getElementById('left-col');
    if (leftCol && window.innerWidth < 900) {
        leftCol.addEventListener('click', function() {
            this.classList.toggle('expanded');
        });
    }
});
</script>

<?php get_footer(); ?>